# This installs Thruk along side Nagios.
# Find it at http://yourteam-nagios.internal.justin.tv/thruk
#
class twitch_nagios::thruk inherits twitch_nagios {
  include apache::mod::rewrite

  # Modify the thruk backend if the lmd class has been loaded
  if defined(Class['twitch_lmd']) {
    $_thruk_backend = 'puppet:///modules/twitch_nagios/lmd_thruk_backend.conf'
  } else {
    $_thruk_backend = 'puppet:///modules/twitch_nagios/thruk_backend.conf'
  }

  apt::source { 'consol_labs':
    location => 'http://labs.consol.de/repo/stable/ubuntu',
    repos    => 'main',
    key      => 'F2F97737B59ACCC92C23F8C7F8C1CA08A57B9ED7',
  }
  package { 'thruk':
    ensure  => 'latest',
    require => Apt::Source['consol_labs'],
  }

  # Override status.pm to fix large installation search performance issues (2/2020)
  # https://wiki.twitch.com/display/VID/Thruk+Large+Installation+Search+Performance+Issues

  file {'/usr/share/thruk/lib/Thruk/Controller/status.pm':
    ensure  => 'present',
    source  => 'puppet:///modules/twitch_nagios/status.pm',
    mode    => '0644',
    owner   => 'root',
    group   => 'root',
    notify  => Class['apache::service'],
    require => Package['thruk'],
  }

  file {'/etc/thruk/cgi.cfg':
    ensure  => 'present',
    source  => 'puppet:///modules/twitch_nagios/thruk-cgi.cfg',
    mode    => '0644',
    owner   => 'root',
    group   => 'root',
    notify  => Class['apache::service'],
    require => Package['thruk'],
  }

  # This file contains the local server.
  file {'/etc/thruk/thruk_local.d/thruk_backend.conf':
    ensure  => 'present',
    source  => $_thruk_backend,
    mode    => '0644',
    owner   => 'root',
    group   => 'root',
    notify  => Class['apache::service'],
    require => Package['thruk'],
  }

  # This is used by Thruk.
  class { 'apache::mod::fcgid':
    options => {
      'AddHandler'   => 'fcgid-script .sh',
    }
  }
  apache::custom_config { 'thruk':
    ensure  => present,
    content => template("${module_name}/thruk-apache.conf.erb"),
  }

  file { [ '/etc/apache2/conf-enabled/thruk.conf', '/etc/apache2/conf-enabled/thruk_cookie_auth_vhost.conf' ]:
    ensure  => 'absent',
    require => Package['thruk'],
  }

}
