#this is for the video-nagios override found in heira/twitch_role/production
class twitch_nagios::video_specifics (
  $secret_name           = "${::twitch_team}/${twitch_nagios::server_name}-nagios/${twitch_environment}/nagios-unsilence-git-ssh-private-key",
) inherits twitch_nagios {
  require twitch_python::pip::jira
  require twitch_python::pip::boto3
  require twitch_python::pip::requests
  include twitch_nagios
  $vhost_name  = $twitch_nagios::vhost::_vhost_name
  $nrdp_tokens = $twitch_nagios::nrdp::tokens
  $env = pick($twitch_environment, $::twitch_environment, 'staging')
  # Most of the things in this file only go on prod, not staging.
  case $env {
    'production': {
      $nagios_alert_sqs_arn    = 'https://sqs.us-west-2.amazonaws.com/277437172290/nagios_alerts_to_jira.fifo'
    }
    'staging': {
      $nagios_alert_sqs_arn    = 'https://sqs.us-west-2.amazonaws.com/152548578290/nagios_alerts_to_jira.fifo'
    }
  }
  $nagios_alert_sqs_region = 'us-west-2'
  $_ensure_production = $env ? {
    'production' => 'present',
    default      => 'absent',
  }

  # Make Nagios discoverable with Consul
  consul::service { 'nagios':
    consul_tags => [$env],
  }

  # Make a place for custom files, specifically secrets.
  file { '/etc/nagios/video':
    ensure => 'directory',
    owner  => $twitch_nagios::nagios_user,
    group  => $twitch_nagios::nagios_user,
    mode   => '0750',
  }

  # Make the ~nagios .aws folder.
  file { '/var/lib/nagios/.aws':
    ensure => 'directory',
    owner  => $twitch_nagios::nagios_user,
    group  => $twitch_nagios::nagios_user,
    mode   => '0700',
    require => Class['twitch_nagios'],
  }

  file { '/var/lib/nagios/.aws/config':
    ensure  => 'present',
    owner   => $twitch_nagios::nagios_user,
    group   => $twitch_nagios::nagios_user,
    mode    => '0700',
    content => "[default]\nregion = us-west-2",
  }

  file { '/var/lib/nagios/notif_to_alerta.py':
    ensure => 'present',
    owner  => $twitch_nagios::nagios_user,
    group  => $twitch_nagios::nagios_user,
    mode   => '0755',
    source => 'puppet:///modules/twitch_nagios/video_specifics/notif_to_alerta.py',
  }

  file { '/var/lib/nagios/send_alert_to_sqs.py':
    ensure => 'present',
    owner  => $twitch_nagios::nagios_user,
    group  => $twitch_nagios::nagios_user,
    mode   => '0755',
    content => template('twitch_nagios/video_specifics/send_alert_to_sqs.py.erb'),
  }

  file { '/var/lib/nagios/notif_to_kinesis.py':
    ensure => 'present',
    owner  => $twitch_nagios::nagios_user,
    group  => $twitch_nagios::nagios_user,
    mode   => '0755',
    source => 'puppet:///modules/twitch_nagios/video_specifics/notif_to_kinesis.py',
  }

  file { '/var/lib/nagios/send_alert_to_antispam.py':
    ensure => 'present',
    owner  => $twitch_nagios::nagios_user,
    group  => $twitch_nagios::nagios_user,
    mode   => '0755',
    source => 'puppet:///modules/twitch_nagios/video_specifics/send_alert_to_antispam.py',
  }

  file { '/var/lib/nagios/nrdp_guardrail.sh':
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    source  => 'puppet:///modules/twitch_nagios/video_specifics/nrdp_guardrail.sh',
  }

  file { '/var/lib/nagios/check_brood_health.py':
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    content => template('twitch_nagios/video_specifics/check_brood_health.py.erb'),
  }

  file { '/var/lib/nagios/expiring_downtimes.sh':
    ensure => $_ensure_production,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => 'puppet:///modules/twitch_nagios/video_specifics/expiring_downtimes.sh',
  }

  file { '/var/lib/nagios/mail_disabled_notifs.sh':
    ensure => $_ensure_production,
    owner  => $twitch_nagios::nagios_user,
    group  => $twitch_nagios::nagios_user,
    mode   => '0755',
    source => 'puppet:///modules/twitch_nagios/video_specifics/mail_disabled_notifs.sh',
  }

  file { '/var/lib/nagios/downtime_jira_checker.py':
    ensure => $_ensure_production,
    owner  => $twitch_nagios::nagios_user,
    group  => $twitch_nagios::nagios_user,
    mode   => '0755',
    source => 'puppet:///modules/twitch_nagios/video_specifics/downtime_jira_checker.py',
  }

  file { '/var/lib/nagios/auto_unsilence/ignored.yaml':
    ensure => $_ensure_production,
    owner  => root,
    group  => root,
    mode   => '0644',
    source => 'puppet:///modules/twitch_nagios/video_specifics/auto_unsilence_ignored.yaml',
  }

  file { '/var/lib/nagios/auto_unsilence/auto_unsilence.py':
    ensure => $_ensure_production,
    owner  => root,
    group  => root,
    mode   => '0644',
    source => 'puppet:///modules/twitch_nagios/video_specifics/auto_unsilence.py',
  }

  #Shouldn't need this anymore
  twitch_sandstorm_agent::template { 'nagios-unsilence-git-ssh-private-key':
    destination     => '/var/lib/nagios/.ssh/auto_unsilence',
    owner           => $twitch_nagios::nagios_user,
    group           => $twitch_nagios::nagios_group,
    mode            => '0600',
    contents        => "{{ key \"${secret_name}\" }}\n",
    restart_command => '',
    require         => File['/var/lib/nagios/.ssh/'],
  }

  twitch_sandstorm_agent::template { 'aws_credentials':
    ensure      => 'present',
    destination => '/var/lib/nagios/.aws/credentials',
    mode        => '0600',
    owner       => $twitch_nagios::nagios_user,
    group       => $twitch_nagios::nagios_user,
    contents    => template('twitch_nagios/video_specifics/aws_credentials.erb'),
    require     => File['/var/lib/nagios/.aws'],
  }

  twitch_sandstorm_agent::template { 'pagerduty_api':
    destination => '/etc/nagios/video/pagerduty_api_key',
    mode        => '0600',
    owner       => $twitch_nagios::nagios_user,
    group       => $twitch_nagios::nagios_user,
    key         => "video-ops/anti-spam/${env}/pager-duty-api",
    require     => File['/etc/nagios/video'],
  }

  twitch_sandstorm_agent::template { 'jira-private-key':
    ensure      => $_ensure_production,
    destination => '/etc/nagios/video/video-nagios-private.pem',
    mode        => '0600',
    owner       => $twitch_nagios::nagios_user,
    group       => $twitch_nagios::nagios_user,
    key         => "video-ops/video-nagios/${env}/jira-private-key",
    require     => File['/etc/nagios/video'],
  }

  twitch_sandstorm_agent::template { 'jira-token':
    ensure      => $_ensure_production,
    destination => '/etc/nagios/video/jira-token.auth',
    mode        => '0600',
    owner       => $twitch_nagios::nagios_user,
    group       => $twitch_nagios::nagios_user,
    key         => "video-ops/video-nagios/${env}/jira-token",
    require     => File['/etc/nagios/video'],
  }

  twitch_sandstorm_agent::template { 'sqs-id':
    ensure      => 'present',
    destination => '/etc/nagios/video/sqs-id',
    mode        => '0600',
    owner       => $twitch_nagios::nagios_user,
    group       => $twitch_nagios::nagios_user,
    key         => "video-ops/video-nagios/${env}/alert-to-sqs-id",
    require     => File['/etc/nagios/video'],
  }

  twitch_sandstorm_agent::template { 'sqs-key':
    ensure      => 'present',
    destination => '/etc/nagios/video/sqs-key',
    mode        => '0600',
    owner       => $twitch_nagios::nagios_user,
    group       => $twitch_nagios::nagios_user,
    key         => "video-ops/video-nagios/${env}/alert-to-sqs-key",
    require     => File['/etc/nagios/video'],
  }

  twitch_sandstorm_agent::template { 'twitch_networkdb_secret':
    ensure      => 'present',
    destination => '/etc/nagios/video/networkdb.secret',
    mode        => '0600',
    owner       => $twitch_nagios::nagios_user,
    group       => $twitch_nagios::nagios_user,
    key         => "video-ops/video-nagios/${env}/twitch_networkdb_secret",
    require     => File['/etc/nagios/video'],
  }

  twitch_sandstorm_agent::template { 'postgres_secret':
    ensure      => 'absent',
    allow_empty => true,
    delete_dest => true,
    destination => '/etc/nagios/video/.pgpass',
  }

  twitch_sandstorm_agent::template { 'client_id_token':
    ensure      => $_ensure_production,
    destination => '/etc/nagios/video/client_id.token',
    mode        => '0600',
    owner       => $twitch_nagios::nagios_user,
    group       => $twitch_nagios::nagios_user,
    key         => "video-ops/video-nagios/${env}/twitch_client_id",
    require     => File['/etc/nagios/video'],
  }

  cron::job { 'check_brood_health':
    command => '/var/lib/nagios/check_brood_health.py  2>&1 | logger -p local3.info -t check_brood_health',
    user    => $twitch_nagios::nagios_user,
    minute  => '*/5',
    require => File['/var/lib/nagios/check_brood_health.py'],
  }

  cron::job { 'nrdp_guardrail':
    command => '/var/lib/nagios/nrdp_guardrail.sh  2>&1 | logger -p local3.info -t nrdp_guardrail',
    user    => $twitch_nagios::nagios_user,
    minute  => '*/5',
    require => File['/var/lib/nagios/nrdp_guardrail.sh'],
  }

  cron::job { 'auto_unsilence':
    command => '/usr/bin/python /var/lib/nagios/auto_unsilence/auto_unsilence.py',
    user    => $twitch_nagios::nagios_user,
    hour    => '*/12',
    minute  => '0',
  }

  cron::job { 'expiring_downtimes':
    ensure  =>  $_ensure_production,
    command => '/var/lib/nagios/expiring_downtimes.sh video-ops@justin.tv 2>&1 | logger -p local3.info -t nagios-expiring-downtimes',
    user    => $twitch_nagios::nagios_user,
    weekday => '1',
    minute  => '0',
    hour    => '8',
    require => File['/var/lib/nagios/expiring_downtimes.sh'],
  }

  cron::daily { 'downtime_jira_checker':
    ensure  => $_ensure_production,
    command => '/usr/bin/python /var/lib/nagios/downtime_jira_checker.py 2>&1 | logger -p local3.info -t jira_downtime',
    user    => $twitch_nagios::nagios_user,
    minute  => '0',
    hour    => '13',
    require => File['/var/lib/nagios/downtime_jira_checker.py'],
  }

  cron::job { 'mail_disabled_notifs':
    ensure  =>  $_ensure_production,
    command => '/var/lib/nagios/mail_disabled_notifs.sh video-ops@justin.tv 2>&1 | logger -p local3.info -t mail_disabled_notifs',
    user    => $twitch_nagios::nagios_user,
    weekday => '1',
    minute  => '0',
    hour    => '9',
    require => File['/var/lib/nagios/mail_disabled_notifs.sh'],
  }

}
