#!/bin/bash

. /usr/local/lib/twitch-init-vars

# checkin to provisioner
params=(
    "state=netboot image boot complete"
    "final_state=1"
    "to_install=1"
)
MACADDRESS=$(grep -oP "BOOTIF=(01-)?\K\S+" /proc/cmdline|tr - :)
PUPPET_ENVIRONMENT=$(grep -oP "puppet_environment=(\K\w+)" /proc/cmdline) || PUPPET_ENVIRONMENT=production
mkdir -p /etc/facter/facts.d/
echo "puppet_environment=${PUPPET_ENVIRONMENT}" >/etc/facter/facts.d/puppet_environment.txt

wget_retry "http://api.us-west-2.prod.provisioner.live-video.a2z.com/checkin/${MACADDRESS}/$(hostname -f)?$(IFS='&'; echo "${params[*]}")"

# determine currently configured puppet_ca server
puppet_ca_server=$(puppet config print ca_server)
[ -n "$puppet_ca_server" ] && {
    # XXX: provisioner may not know about our new host since we whitelist CIDR blocks to boot this image (le sigh)
    # lets forcefully revoke and clean our puppet cert
    url="https://${puppet_ca_server}:8140/production/certificate_status/$(hostname -f)"
    wget_retry --no-check-certificate --method=PUT --header='Content-Type: text/pson' --body-data='{"desired_state":"revoked"}' "$url"
    wget_retry --no-check-certificate --method=DELETE "$url"
    PROXY_FILE=/etc/profile.d/proxy.sh ; [ -f $PROXY_FILE ] && . $PROXY_FILE
    /usr/bin/puppet agent --test --environment=${PUPPET_ENVIRONMENT} 2>&1 | tee -a /var/log/firstboot.log | logger -p local3.info -t puppet-cron
}
