#!/usr/bin/env python3
import json
import subprocess

kernel_params = json.loads(
     subprocess.check_output("/usr/bin/facter -p -j cmdline", shell=True)
     )
cmdline = kernel_params['cmdline']

if 'ip' in cmdline:
    if cmdline['ip'] == 'public':
        with open("/etc/dhcp/dhclient.conf", "a+") as dhclient_conf:
            if 'send user-class "PUBLIC";' in dhclient_conf.read():
                print("Already configured")
            else:
                dhclient_conf.write('send user-class "PUBLIC";\n')
