# twitch_netboot::fstab
class twitch_netboot::fstab {

  mount { '/dev/shm' :
    ensure  => 'present',
    device  => 'tmpfs',
    options => 'rw,nosuid,nodev,size=30%',
    fstype  => 'tmpfs',
    atboot  => true,
    pass    => 0,
  }

  mount { '/run' :
    ensure  => 'present',
    device  => 'tmpfs',
    options => 'rw,nosuid,noexec,relatime,size=15%,mode=0755',
    fstype  => 'tmpfs',
    atboot  => true,
    pass    => 0,
  }

  mount { '/tmp' :
    ensure  => 'present',
    device  => 'tmpfs',
    options => 'rw,nosuid,nodev,relatime,size=15%,mode=1777',
    fstype  => 'tmpfs',
    atboot  => true,
    pass    => 0,
  }

  mount { '/sys/fs/cgroup' :
    ensure  => 'present',
    device  => 'tmpfs',
    options => 'ro,nosuid,nodev,noexec,size=15%,mode=0755',
    fstype  => 'tmpfs',
    atboot  => true,
    pass    => 0,
  }

}
