# twitch_netboot
class twitch_netboot {

  require twitch_apt
  require twitch_teamd
  require wget
  include twitch_netboot::fstab
  include twitch_netboot::services

  file { '/etc/dhcp/dhclient.conf':
    ensure => 'present',
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
    source => "puppet:///modules/${module_name}/etc/dhcp/dhclient.conf",
  }

  file { '/etc/dhcp/dhclient-exit-hooks.d/resolv':
    ensure => 'present',
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
    source => "puppet:///modules/${module_name}/etc/dhcp/dhclient-exit-hooks.d/resolv",
  }

  file { '/etc/dhcp/dhclient-exit-hooks.d/hostname':
    ensure => 'present',
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
    source => "puppet:///modules/${module_name}/etc/dhcp/dhclient-exit-hooks.d/hostname",
  }

  file { '/etc/dhcp/dhclient-exit-hooks.d/twitch_hook':
    ensure => 'present',
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
    source => "puppet:///modules/${module_name}/etc/dhcp/dhclient-exit-hooks.d/twitch_hook",
  }

  # only needed during netboot. Not manageable by puppet
  if $::packer_build_name {

    $live_boot_packages = ['live-boot','live-tools']

    package {$live_boot_packages:
      ensure  => present,
      require => Package['live-config-systemd']
    }

    file { '/lib/live/boot/9991-netbase.sh':
      ensure  => 'present',
      owner   => 'root',
      group   => 'root',
      mode    => '0755',
      source  => "puppet:///modules/${module_name}/lib/live/boot/9991-netbase.sh",
      require => Package['live-boot'],
    }

    file { '/lib/live/boot/9991-fstab.sh':
      ensure  => 'present',
      owner   => 'root',
      group   => 'root',
      mode    => '0755',
      source  => "puppet:///modules/${module_name}/lib/live/boot/9991-fstab.sh",
      require => Package['live-boot'],
    }

    # Download live-config packages from bionic to better integrate with systemd
    $live_config_version='5.20190519'

    archive { "/tmp/live-config-systemd_${live_config_version}_all.deb":
      ensure   => present,
      source   => "http://archive.ubuntu.com/ubuntu/pool/universe/l/live-config/live-config-systemd_${live_config_version}_all.deb",
      provider => 'wget',
      require  => Package['wget'],
    }

    archive { "/tmp/live-config_${live_config_version}_all.deb":
      ensure   => present,
      source   => "http://archive.ubuntu.com/ubuntu/pool/universe/l/live-config/live-config_${live_config_version}_all.deb",
      provider => 'wget',
      require  => Package['wget'],
    }

    # maybe the debs will install this.
    #chroot ${IMAGE_ROOT} apt-get install --no-install-recommends -y systemd-sysv

    package {'live-config-systemd':
      ensure   => latest,
      provider => 'dpkg',
      source   => "/tmp/live-config-systemd_${live_config_version}_all.deb",
      require  => Archive["/tmp/live-config-systemd_${live_config_version}_all.deb"],
    }

    -> package {'live-config':
      ensure   => latest,
      provider => 'dpkg',
      source   => "/tmp/live-config_${live_config_version}_all.deb",
      require  => Archive["/tmp/live-config_${live_config_version}_all.deb"],
    }
  }

  # link network manger to /bin/true to prevent live-boot scripts from
  # generating a bad /etc/resolv.conf
  file { '/usr/sbin/NetworkManager':
    ensure => link,
    target => '/bin/true',
  }

  # required to allow preseed to use the squashfs image during provisioning
  package { ['libtext-iconv-perl']:
    ensure => 'present',
  }

}
