# twitch_netboot::services
class twitch_netboot::services {
  file { '/usr/local/sbin/twitch_bootstrap.sh':
    ensure => present,
    source => "puppet:///modules/${module_name}/usr/local/sbin/twitch_bootstrap.sh",
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  ->  systemd::service {'netboot-twitchbootstrap':
    description       => 'Twitch Netboot Bootstrap Service',
    after_units       => ['network-online.target', 'local-fs.target'],
    wants             => ['network-online.target', 'local-fs.target'],
    execstart         => '/usr/local/sbin/twitch_bootstrap.sh',
    type              => 'oneshot',
    remain_after_exit => true,
    wantedby          => ['multi-user.target'],
  }

  -> service {'netboot-twitchbootstrap':
    enable   => true,
  }

  file { '/usr/local/sbin/provisioner_checkin.sh':
    ensure => present,
    source => "puppet:///modules/${module_name}/usr/local/sbin/provisioner_checkin.sh",
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  ->  systemd::service {'netboot-provisioner_checkin':
    description       => 'Provisioner Checkin (one time)',
    after_units       => ['network-online.target', 'time-sync.target', 'netboot-twitchbootstrap.service', 'netboot-mgdb.service'],
    wants             => ['network-online.target', 'time-sync.target', 'netboot-twitchbootstrap.service', 'netboot-mgdb.service'],
    before_units      => ['puppet.service'],
    execstart         => '/usr/local/sbin/provisioner_checkin.sh',
    type              => 'oneshot',
    remain_after_exit => true,
    wantedby          => ['multi-user.target'],
  }

  -> service {'netboot-provisioner_checkin':
    enable   => true,
  }

  file { '/usr/local/sbin/kontron_metadata.sh':
    ensure => present,
    source => "puppet:///modules/${module_name}/usr/local/sbin/kontron_metadata.sh",
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  ->  systemd::service {'kontron-metadata':
    description        => 'Kontron Metadata Gatherer',
    execstart          => '/usr/local/sbin/kontron_metadata.sh',
    restart            => 'on-failure',
    restart_sec        => 30,
    startlimitinterval => 200,
    startlimitburst    => 5,
    wantedby           => ['multi-user.target'],
  }

  -> service {'kontron-metadata':
    enable   => true,
  }

  file { '/usr/local/sbin/twitch_net_teardown.sh':
    ensure => present,
    source => "puppet:///modules/${module_name}/usr/local/sbin/twitch_net_teardown.sh",
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  -> systemd::service { 'net-teardown':
    description       => 'Tear down network before configuring team interface',
    before_units      => ['teamd.service'],
    execstart         => '/usr/local/sbin/twitch_net_teardown.sh',
    type              => 'oneshot',
    remain_after_exit => true,
  }

  -> service { 'net-teardown':
    enable => true,
  }

  file { '/usr/local/sbin/twitch_dhclient_update.py':
    ensure => present,
    source => "puppet:///modules/${module_name}/usr/local/sbin/twitch_dhclient_update.py",
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  -> systemd::service { 'twitch_dhclient_update':
    description       => 'Configure dhclient to request private/public ip',
    before_units      => ['networking.service'],
    execstart         => '/usr/local/sbin/twitch_dhclient_update.py',
    type              => 'oneshot',
    remain_after_exit => true,
  }

  -> service { 'twitch_dhclient_update':
    enable => true,
  }

}
