# shellcheck shell=bash
# no need for shebang - this file is loaded from charts.d.plugin
# SPDX-License-Identifier: GPL-3.0-or-later

# netdata
# real-time performance and health monitoring, done right!
# (C) 2016 Costa Tsaousis <costa@tsaousis.gr>
#

# if this chart is called X.chart.sh, then all functions and global variables
# must start with X_

# _update_every is a special variable - it holds the number of seconds
# between the calls of the _update() function
ssm_agent_update_every=10

# the priority is used to sort the charts on the dashboard
# 1 = the first chart
ssm_agent_priority=150000

ssm_agent_activity_seconds_ago=

ssm_agent_get() {
	# do all the work to collect / calculate the values
	# for each dimension
	#
	# Remember:
	# 1. KEEP IT SIMPLE AND SHORT
	# 2. AVOID FORKS (avoid piping commands)
	# 3. AVOID CALLING TOO MANY EXTERNAL PROGRAMS
	# 4. USE LOCAL VARIABLES (global variables may overlap with other modules)

        local now=$(date +%s)
        local last_activity_ts=$(date -d "$(grep amazon-ssm-agent /var/log/daemon.log |tail -n1|awk '{print $1, $2, $3}')" +%s)
        ssm_agent_activity_seconds_ago=$((now - last_activity_ts))

	# this should return:
	#  - 0 to send the data to netdata
	#  - 1 to report a failure to collect the data
	return 0
}

# _check is called once, to find out if this chart should be enabled or not
ssm_agent_check() {
	# this should return:
	#  - 0 to enable the chart
	#  - 1 to disable the chart

	return 0
}

# _create is called once, to create the charts
ssm_agent_create() {
	# create the chart with 3 dimensions
	cat <<EOF
CHART ssm_agent.activity_seconds_ago '' "SSM agent activity" "activity_seconds_ago" activity_seconds_ago activity_seconds_ago line $ssm_agent_priority $ssm_agent_update_every
DIMENSION activity_seconds_ago '' absolute 1 1
EOF

	return 0
}

# _update is called continuously, to collect the values
ssm_agent_update() {
	# the first argument to this function is the microseconds since last update
	# pass this parameter to the BEGIN statement (see bellow).

	ssm_agent_get || return 1

	# write the result of the work.
	cat <<VALUESEOF
BEGIN ssm_agent.activity_seconds_ago $1
SET activity_seconds_ago = $ssm_agent_activity_seconds_ago
END
VALUESEOF

	return 0
}
