# netdata
class twitch_netdata (
  $version = $twitch_netdata::params::version
) inherits twitch_netdata::params {
  if $version == 'absent' {
    service { 'netdata':
      ensure => 'stopped',
      enable => false,
    }

    -> file { '/etc/netdata/health_alarm_notify.conf':
      ensure => 'absent'
    }

    -> file { '/etc/netdata/python.d/haproxy.conf':
      ensure => 'absent'
    }

    -> file { '/etc/netdata/python.d/varnish.conf':
      ensure => 'absent'
    }

    -> file { '/etc/cron.d/alerta_heartbeat':
      ensure => 'absent'
    }

    -> file { '/etc/netdata/netdata.conf':
      ensure => 'absent'
    }

    -> file { '/etc/netdata/health.d/ssm_agent.conf':
      ensure => 'absent'
    }

    -> file { '/usr/libexec/netdata/charts.d/ssm_agent.chart.sh':
      ensure => 'absent'
    }

    -> package { 'netdata':
      ensure => 'absent'
    }
  } else {
    package { 'netdata':
      ensure => $version
    }

    -> file { '/etc/netdata/health_alarm_notify.conf':
      notify => Service['netdata'],
      owner  => 'root',
      group  => 'root',
      mode   => '0644',
      source => "puppet:///modules/${module_name}/health_alarm_notify.conf",
    }

    -> file { '/etc/netdata/python.d/haproxy.conf':
      notify => Service['netdata'],
      owner  => 'root',
      group  => 'root',
      mode   => '0644',
      source => "puppet:///modules/${module_name}/haproxy.conf",
    }

    -> file { '/etc/netdata/python.d/varnish.conf':
      notify => Service['netdata'],
      owner  => 'root',
      group  => 'root',
      mode   => '0644',
      source => "puppet:///modules/${module_name}/varnish.conf",
    }

    -> file { '/etc/cron.d/alerta_heartbeat':
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => template("${module_name}/alerta_heartbeat.erb"),
    }

    -> file { '/etc/netdata/netdata.conf':
      notify  => Service['netdata'],
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => template("${module_name}/netdata.conf.erb"),
    }

    -> file { '/etc/netdata/health.d/ssm_agent.conf':
      notify => Service['netdata'],
      owner  => 'root',
      group  => 'root',
      mode   => '0644',
      source => "puppet:///modules/${module_name}/ssm_agent.conf",
    }

    -> file { '/usr/libexec/netdata/charts.d/ssm_agent.chart.sh':
      notify => Service['netdata'],
      owner  => 'root',
      group  => 'root',
      mode   => '0644',
      source => "puppet:///modules/${module_name}/ssm_agent.chart.sh",
    }

    -> service { 'netdata':
      ensure => 'running',
      enable => true,
    }
  }
}
