# This class contains all the monitoring directives for network engineering hosts.
#
class twitch_neteng::monitoring (
  $nrdp_load = '-w 2.55,2.55 -c 2.80,2.80',
  $nrdp_mem  = '-w 80:50 -c 90:70',
  $nrdp_disk = '-w 25% -c 15% -r /dev/ -C -w 35% -c 20% -p /boot',
  $contact   = 'neteng_pagerduty',
  $econtact  = 'neteng_email_only',
) {
  include twitch_neteng

  if $::ec2_metadata == undef {
    # This one alerts syseng since it's a hardware problem.
    twitch_servicecheck::passive { 'ipmi_sensors':
      command  => '/usr/local/monitor_scripts/check_ipmi_sensor -v --nosel',
      user     => 'nagios',
      interval => 5,
      options  => {
        'use' => 'passive-service-email',
      },
    }
    twitch_servicecheck::passive { 'link_aggregation':
      command  => '/usr/local/monitor_scripts/check_team.py',
      user     => 'nagios',
      interval => 1,
      options  => {
        contact_groups => $contact,
      },
    }
    twitch_servicecheck::passive { 'raid-array':
      command  => '/usr/local/monitor_scripts/check_raid.pl',
      interval => 2,
      options  => {
        contact_groups => $contact,
      },
    }
  } # end bare metal.

  twitch_servicecheck::passive { 'load':
    command  => "/usr/lib/nagios/plugins/check_load -r ${nrdp_load}",
    interval => 1,
    options  => {
      contact_groups => $contact,
    },
  }
  twitch_servicecheck::passive { 'shared-memory':
    command  => '/usr/lib/nagios/plugins/check_disk -w 20% -c 10% -p /run/shm',
    interval => 1,
    options  => {
      contact_groups => $contact,
    },
  }
  twitch_servicecheck::passive { 'ntp':
    command  => '/usr/local/monitor_scripts/check_chrony_health',
    interval => 3,
    options  => {
      contact_groups => $contact,
    },
  }
  twitch_servicecheck::passive { 'memory':
    command  => "/usr/local/monitor_scripts/check_memswap.pl ${nrdp_mem}",
    interval => 1,
    options  => {
      contact_groups => $contact,
    },
  }
  twitch_servicecheck::passive { 'disk space':
    command  => "/usr/lib/nagios/plugins/check_disk ${nrdp_disk} -i /srv/node/.* -i /snap",
    interval => 3,
    options  => {
      contact_groups => $contact,
    },
  }
}
