# private class to configure directories before files
class twitch_nginx::config_dirs(
  $ensure            = $twitch_nginx::ensure,
  $nginx_html_dir    = $twitch_nginx::params::nginx_html_dir,
  $nginx_vhost_dir   = $twitch_nginx::params::nginx_vhost_dir,
  $nginx_log_dir     = $twitch_nginx::params::nginx_log_dir,
  $nginx_confssl_dir = $twitch_nginx::params::nginx_confssl_dir,
) inherits twitch_nginx::params {

  validate_string($nginx_html_dir)
  validate_string($nginx_vhost_dir)
  validate_string($nginx_log_dir)
  validate_string($nginx_confssl_dir)

  $dir_ensure = $ensure ? {
    'absent' => $ensure,
    default  => 'directory'
  }

  # dirs
  file { $nginx_html_dir:
    ensure  => $dir_ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    require => Class['twitch_nginx::install']
  }

  file { $nginx_vhost_dir:
    ensure => $dir_ensure,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    require => Class['twitch_nginx::install']
  }

  file { $nginx_log_dir:
    ensure => $dir_ensure,
    owner  => 'nobody',
    group  => 'nogroup',
    mode   => '0755',
    require => Class['twitch_nginx::install']
  }

  file { $nginx_confssl_dir:
    ensure => $dir_ensure,
    owner  => 'root',
    group  => 'root',
    mode   => '0700',
    require => Class['twitch_nginx::install']
  }
}
