# private class to configure nginx files
class twitch_nginx::config_files (
  $ensure                 = $twitch_nginx::ensure,
  $nginx_config           = $twitch_nginx::params::nginx_config,
  $nginx_conf_dir         = $twitch_nginx::params::nginx_conf_dir,
  $nginx_ulimit           = $twitch_nginx::params::nginx_ulimit,
  $worker_processes       = $twitch_nginx::params::worker_processes,
  $has_twitch_scheme      = $twitch_nginx::params::has_twitch_scheme,
  $has_nginx_size         = $twitch_nginx::params::has_nginx_size,
  $server_name_hash_size  = $twitch_nginx::params::server_name_hash_size,
  $l3_proto_var           = $twitch_nginx::params::l3_proto_var,
  $lb_proto_var           = $twitch_nginx::params::lb_proto_var,
  $keepalive_timeout      = $twitch_nginx::params::keepalive_timeout,
  $keepalive_requests     = $twitch_nginx::params::keepalive_requests,
  $http_status_filtering  = $twitch_nginx::params::http_status_filtering,
  $timing_origin_patterns = $twitch_nginx::params::timing_origin_patterns,
  $timing_origin_default  = $twitch_nginx::params::timing_origin_default,
  $modules_list           = $twitch_nginx::params::modules_list,
) inherits twitch_nginx::params {

  file { '/etc/default/nginx':
    ensure  => $ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => "ulimit -n ${nginx_ulimit}",
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::install'],
  }

  if str2bool($::systemd) {
    twitch_systemd::unit_file { 'nginx.service':
      ensure  => $ensure,
      content => template("${module_name}/nginx.service.erb"),
    }
  } else {
    file { '/etc/init.d/nginx':
      ensure  => $ensure,
      content => template("${module_name}/nginx.init.erb"),
      owner   => 'root',
      group   => 'root',
      mode    => '0755',
      backup  => false,
      require => Class['twitch_nginx::install']
    }
  }

  file { $nginx_config:
    ensure  => $ensure,
    content => template("${module_name}/nginx.conf.erb"),
    notify  => Class['twitch_nginx::service'],
    require => [Class['twitch_nginx::config_dirs'],Class['twitch_nginx::install']]
  }

  file { "${nginx_conf_dir}/mime.types":
    ensure  => $ensure,
    content => template("${module_name}/mime.types.erb"),
    notify  => Class['twitch_nginx::service'],
    require => [Class['twitch_nginx::config_dirs'],Class['twitch_nginx::install']]
  }

  file { "${nginx_conf_dir}/log_format.conf":
    ensure  => $ensure,
    content => template("${module_name}/log_format.conf.erb"),
    notify  => Class['twitch_nginx::service'],
    require => [Class['twitch_nginx::config_dirs'],Class['twitch_nginx::install']]
  }
}
