class twitch_nginx::cron (
  $cron_ensure = $twitch_nginx::params::cron_ensure,
  $random_minute = fqdn_rand(59,'rotate_nginx_logs')
) inherits twitch_nginx::params {
  validate_string($cron_ensure)

  # if hourly log rotations are needed set to:
  # twitch_nginx::logrotate::nginx_logrotate_every = hour
  cron::hourly { 'rotate_nginx_logs':
    ensure  => 'absent',
    command => 'ionice -c 3 nice -n19 /usr/sbin/logrotate -f /etc/logrotate.d/nginx',
    user    => 'root',
    minute  => $random_minute,
  }
  cron { 'rotate_nginx_logs': user => 'root', ensure => 'absent'}
}
