# main nginx class, installs basic nginx with no vhosts
# use twitch_nginx::vhost to install vhosts
# use twitch_nginx::upstream to install upstream servers
class twitch_nginx (
  $ensure        = 'present',
  $nginx_version = $twitch_nginx::params::nginx_version,
  $worker_processes = $twitch_nginx::params::worker_processes,
) inherits twitch_nginx::params {

  # primary ordering by classes
  anchor { "${module_name}::begin": } ->
  class { "${module_name}::install": } ->
  class { "${module_name}::config_dirs": } ->
  class { "${module_name}::config_files": } ~>
  class { "${module_name}::logrotate": } ->
  class { "${module_name}::cron": } ->
  class { "${module_name}::service": } ->
  anchor { "${module_name}::end": }

  # secondary ordering
  # we want all vhosts to notify service
  Class["${module_name}::config_files"] ->
  Twitch_nginx::Vhost <| |> ~>
  Class["${module_name}::service"]

}
