# private class to install the actual nginx package
class twitch_nginx::install (
  $ensure = $twitch_nginx::ensure,
  $nginx_package = $twitch_nginx::params::nginx_package,
  $nginx_dir = $twitch_nginx::params::nginx_dir,
) inherits twitch_nginx::params {

  validate_string($nginx_package)
  validate_string($nginx_dir)

  # package ensure
  $pkg_ensure = $ensure ? {
    default             => $twitch_nginx::nginx_version,
    /^(latest|absent)$/ => $ensure,
  }

  package { $nginx_package:
    ensure => $pkg_ensure,
  }

  apt::pin { 'nginx':
    ensure   => present,
    packages => 'nginx',
    priority => 600,
    version  => $twitch_nginx::nginx_version,
  }

  # this is because our custom packaging doesn't create
  # a service, so upon removal, apt wont stop anything
  # if we want to ensure that nginx is absent, we need
  # to manually kill it
  if ($ensure == 'absent') {
    exec { 'pkill nginx':
      onlyif => 'pgrep nginx',
    }

    # we remove the nginx dir entirely
    file { $nginx_dir:
      ensure => $ensure,
      purge  => true,
      force  => true,
    }
  }
}
