class twitch_nginx::logrotate (
  $nginx_logrotate_compresscmd = $twitch_nginx::params::nginx_logrotate_compresscmd,
  $nginx_logrotate_compressoptions = $twitch_nginx::params::nginx_logrotate_compressoptions,
  $nginx_logrotate_compressext = $twitch_nginx::params::nginx_logrotate_compressext,
  $nginx_rotate_every   = $twitch_nginx::params::nginx_logrotate_every,
  $nginx_rotate_size    = $twitch_nginx::params::nginx_logrotate_size,
  $nginx_rotate_time    = $twitch_nginx::params::nginx_logrotate_time,
  $nginx_logrotate_path = $twitch_nginx::params::nginx_logrotate_path,
  $nginx_pidfile        = $twitch_nginx::params::nginx_pidfile,
  $upload_s3            = false,
  $s3_bucket            = $twitch_nginx::params::s3_bucket,
) inherits twitch_nginx::params {

  if $upload_s3 {
    $dateext    = true
    $dateformat = '-%Y-%m-%d-%s'
    twitch_s3_backup::cron { "nginx_logs":
      source         => "${twitch_nginx::nginx_log_dir}/",
      s3_bucket      => $s3_bucket,
    }
  } else {
    $dateext    = undef
    $dateformat = undef
  }

  logrotate::rule { 'nginx':
    ensure          => present,
    path            => $nginx_logrotate_path,
    missingok       => true,
    size            => $nginx_rotate_size,
    rotate          => $nginx_rotate_time,
    rotate_every    => $nginx_rotate_every,
    dateext         => $dateext,
    dateformat      => $dateformat,
    sharedscripts   => true,
    compress        => true,
    delaycompress   => false,
    compresscmd     => $nginx_logrotate_compresscmd,
    compressoptions => $nginx_logrotate_compressoptions,
    compressext     => $nginx_logrotate_compressext,
    create          => true,
    create_mode     => '0644',
    create_owner    => 'nobody',
    postrotate      => join([
        "test ! -f ${nginx_pidfile} || kill -USR1 `cat ${nginx_pidfile}`",
        'if systemctl -q is-active awslogs; then',
        '  /usr/sbin/service awslogs restart > /dev/null 2>&1',
        'fi' ], "\n"),
  }

}
