# nginx params class to track default parameters for class
class twitch_nginx::params {
  $nginx_package         = 'nginx'
  $nginx_service         = 'nginx'
  $nginx_ulimit          = '262144'
  $server_name_hash_size = 64
  $nginx_version         = "1.12.2-2${::lsbdistcodename}"
  $nginx_dir             = '/usr/local/nginx'
  $nginx_conf_dir        = "${nginx_dir}/conf"
  $nginx_confssl_dir     = "${nginx_conf_dir}/ssl"
  $nginx_confd_dir       = "${nginx_dir}/conf.d"
  $nginx_html_dir        = "${nginx_dir}/html"
  $nginx_vhost_dir       = "${nginx_conf_dir}/servers"
  $nginx_log_dir         = '/var/log/nginx'
  $nginx_error_log       = "${nginx_log_dir}/error.log"

  case $::cluster {
    'ingest', 'usher', 'video': {}
    default: {
      $nginx_access_log  = "${nginx_log_dir}/access.log"
    }
  }

  $nginx_access_log_type = $::cluster ? {
    'web'         => 'expanded',
    'rails-nginx' => 'expanded',
    default       => 'combined',
  }

  $nginx_config          = "${nginx_conf_dir}/nginx.conf"

  $nginx_pidfile         = '/var/run/nginx.pid'
  $nginx_logrotate_path  = ["${nginx_log_dir}/*.log"]

  $worker_connections    = 65536
  $worker_processes      = $::cluster ? {
    'ingest' => 1,
    'video-tier1' => 'auto',
    default  => 8,
  }
  $sendfile              = 'on'
  $server_tokens         = 'off'

  $keepalive_timeout     = 0
  $keepalive_requests    = 100

  $ssl_session_timeout   = '10m'
  $ssl_session_cache     = $::cluster ? {
    'web'         => 'shared:SSL:100m',
    'rails-nginx' => 'shared:SSL:100m',
    default       => 'shared:SSL:10m',
  }

  $has_nginx_size        = $::cluster ? {
    'web'         => true,
    'rails-nginx' => true,
    default       => false,
  }

  $has_twitch_scheme     = $::cluster ? {
    'web'         => true,
    'rails-nginx' => true,
    default       => false,
  }

  $has_gzip              = $::cluster ? {
    'web'         => true,
    'rails-nginx' => true,
    default       => false,
  }

  $nginx_logrotate_time  = $::hostname ? {
    /^sc/      => 7,
    /^stats3$/ => 0,
    /^video/   => 48,
    default    => 3
  }

  $nginx_logrotate_every = 'day'
  $nginx_logrotate_size  = undef

  case $::hostname {
    /^video/: {
      $nginx_logrotate_compresscmd     = '/bin/gzip'
      $nginx_logrotate_compressoptions = '-1'
      $nginx_logrotate_compressext     = '.gz'
    }
    default: {
      $nginx_logrotate_compresscmd     = '/usr/bin/pbzip2'
      $nginx_logrotate_compressoptions = '-1p4'
      $nginx_logrotate_compressext     = '.bz2'
    }
  }

  $l3_proto_var           = 'http_x_clientprotocol'
  $lb_proto_var           = 'http_x_forwarded_proto'
  $http_status_filtering  = false
  $timing_origin_patterns = []
  $timing_origin_default  = ''
  $modules_list           = [ 'ngx_http_graphite_module', 'ngx_http_upstream_consistent_hash_module' ]

}
