# private class: configures nginx service
class twitch_nginx::service (
  $ensure          = $twitch_nginx::ensure,
  $nginx_service   = $twitch_nginx::params::nginx_service,
) inherits twitch_nginx::params {

  $service_ensure = $ensure ? {
    'absent'  => 'stopped',
    default   => 'running'
  }

  $service_enable = $service_ensure ? {
    'absent' => false,
    default  => true
  }

  $reload_cmd = str2bool($::systemd) ? {
    true    => 'systemctl reload nginx',
    default => '/etc/init.d/nginx configtest && /etc/init.d/nginx reload'
  }

  # if we have systemd, require that class, else just the exec
  $service_requires = str2bool($::systemd) ? {
    true    => [Class['::systemd'],Exec['Gracefully upgrading nginx versions'],],
    default => [Exec['Gracefully upgrading nginx versions']]
  }

  # we dont define the class, if we want it to be absent
  if $ensure != 'absent' {
    exec { 'Gracefully upgrading nginx versions':
      command   => "pkill -USR2 -F ${nginx_pidfile} && sleep 5 && pkill -WINCH -F ${nginx_pidfile}.oldbin && sleep 5 && pkill -QUIT -F ${nginx_pidfile}.oldbin",
      provider  => 'shell',
      logoutput => 'on_failure',
      onlyif    => "/bin/readlink /proc/$(cat ${nginx_pidfile})/exe |grep '(deleted)'",  # validate first that the old binary is gone
    }

    service { $nginx_service:
      ensure    => $service_ensure,
      enable    => $service_enable,
      hasstatus => false,
      restart   => $reload_cmd,
      pattern   => 'nginx: master process', # because puppet doesnt find 'nginx' in process table
      require   => $service_requires,
    }
  }
}
