# public vhost definition
# used to poop files into conf/servers
define twitch_nginx::vhost(
  $source  = undef,
  $content = undef,
  $ensure  = undef,
) {
  include twitch_nginx

  $nginx_vhost_dir = $twitch_nginx::nginx_vhost_dir
  validate_absolute_path($nginx_vhost_dir)

  # if $ensure is provided use it, otherwise grab module default
  if $ensure {
    $real_ensure = $ensure
  } elsif $twitch_nginx::ensure {
    $real_ensure = $twitch_nginx::ensure
  } else {
    $real_ensure = 'present'
  }

  file { "${nginx_vhost_dir}/${name}.conf":
    ensure  => $real_ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => $source,
    content => $content,
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs'],
  }
}
