# Twitch NRDC Puppet Module

Use these hiera values to power this module:
```
twitch_nrdc::servicechecks : hash  : passive service checks to run
twitch_nrdc::activechecks  : hash  : active checks only stored in consul for ncgp.
twitch_nrdc::hostparams    : hash  : nagios host parameters, used by ncgp.
twitch_nrdc::hostgroups    : array : additional nagios host groups, used by ncgp.
```

You may also add service checks in manifests:
```ruby
twitch_nrdc::servicecheck { 'memory':
  command => 'check_mem -w 50% -c 70%',
}
twitch_nrdc::servicecheck { 'load':
  command => 'check_load -w 50% -c 70%',
}
```
