# nrdc puppet module
#
class twitch_nrdc (
  $ensure        = $twitch_nrdc::params::ensure,
  $monitor_env   = $twitch_nrdc::params::monitor_env,
  $listen        = $twitch_nrdc::params::listen,
  $token         = $twitch_nrdc::params::token,
  $allowed_users = $twitch_nrdc::params::allowed_users,
  $env_vars      = $twitch_nrdc::params::env_vars,
  $hostgroups    = $twitch_nrdc::params::hostgroups,
  $hostparams    = $twitch_nrdc::params::hostparams,
) inherits twitch_nrdc::params {
  $servicechecks = hiera_hash('twitch_nrdc::servicechecks', undef)
  $activechecks  = hiera_hash('twitch_nrdc::activechecks', undef)

  class { '::nrdc':
    ensure        => $ensure,
    listen        => $listen,
    token         => $token,
    allowed_users => $allowed_users,
    env_vars      => $env_vars,
  }

  # Setup recievers based on env
  $env = pick($::twitch_environment, $twitch_environment, 'staging')

  $nrdp_host = $env ? {
    /^canary/  => 'video-nagios.internal.justin.tv',
    production => 'video-nagios.internal.justin.tv',
    default    => 'video-nagios-staging.internal.justin.tv',
  }

  nrdc::receiver { "video-nagios-${env}":
    url       => "https://${nrdp_host}/nrdp/",
    http_vars => 'token=64c147c4ba4a97728d1a3b00c272ca0d&cmd=submitcheck',
  }

  # This allows resource creation from hiera. Aovid this where possible.
  # This is for "emergencies" only.
  if !empty($servicechecks) {
    ensure_resources('twitch_nrdc::servicecheck', $servicechecks)
  }
  if !empty($activechecks) {
    ensure_resources('twitch_nrdc::activecheck', $activechecks)
  }
  # Uninstall a modified datadog template.
  file { '/etc/nrdc/datadog.template.json':
    ensure  => 'absent',
    require => Class['::nrdc'],
  }
  # Small shell script to easily run nrdc once.
  file { '/usr/local/bin/nrdconce':
    ensure => $ensure,
    mode   => '0755',
    owner  => 'root',
    group  => 'root',
    source => 'puppet:///modules/twitch_nrdc/nrdconce',
  }
}
