# NRDC default parameters.
#
class twitch_nrdc::params {
  $ensure        = present
  # This is used by puppetdb lookups (ncgp)
  $monitor_env   = pick($::twitch_environment, $twitch_environment, 'development')
  $listen        = '0.0.0.0:5668'
  # This is used for incoming connections, not sending metrics to receivers (nagios).
  $token         = '234werd123-s1234-a1234a123a-lllkju'
  $allowed_users = [
    'nobody',
    'puppet',
    'nagios',
    'consul',
    'openvpn_as',
  ]
  $env_vars = [
    'PATH=/bin:/usr/bin:/sbin:/usr/sbin:/opt/nagios_checks:/usr/local/monitor_scripts:/usr/lib/twitch/monitoring-plugins:/usr/lib/twitch/monitoring-scripts:/usr/lib/nagios/plugins',
    'HTTPS_PROXY=http://proxy.internal.justin.tv:9797/',
    'NO_PROXY=127.0.0.0/8,10.0.0.0/8,.internal.justin.tv,.justin.tv,.twitch.tv',
  ]
  $hostgroups = []
  $hostparams = {}
}
