# Creates service checks for NRDC. Using this will install NRDC.
#
define twitch_nrdc::servicecheck (
  $command,
  $ensure         = present,
  $handler        = '',
  $hostname       = '',
  $service_name   = $name,
  $timeout        = 60,
  $interval       = 5,
  $retry_interval = join(values_at(sort([0+2, 0+pick($interval, 5)]), 0)),
  $retry          = 3,
  $options        = {},
  $user           = '',
) {
  include twitch_nrdc
  validate_hash($options)

  nrdc::servicecheck { $service_name:
    ensure         => $ensure,
    command        => $command,
    handler        => $handler,
    hostname       => $hostname,
    timeout        => $timeout,
    interval       => $interval,
    retry_interval => $retry_interval,
    retry          => $retry,
    user           => $user,
  }
}
