## Overview

Puppet module to manage send_nrdp.py installation and configuration.
Provides easy way to create passive NRDP checks similar to NRPE module.


## Module Description

This module installs and configures [send_nrdp.py](https://exchange.nagios.org/directory/send_nrdp-Python-NRDP-Client/details).
It allows you to quickly add a passive Nagios check that reports back data via NRDP.

## Setup

This will install the scripts used by twitch_nrdp::check.
```puppet
include twitch_nrdp
```

### Create service check using a nagios-style script:

This works well to convert NRPE checks to passive.
These are all examples of that:

```puppet
twitch_nrdp::check { 'check_chrony_health':
  service_name   => 'ntp',
  command        => '/usr/local/monitor_scripts/check_chrony_health',
  interval       => 5,
  retry_interval => 2,
  retry          => 3,
}
```
```puppet
twitch_nrdp::check { 'check_bond':
  ensure       => 'present',
  service_name => 'bond',
  command      => '/usr/local/monitor_scripts/check_bond',
  interval     => 2,
  require      => File['/usr/local/monitor_scripts/check_bond'],
}
```

## Parameters

#### These parameters are available in the `twitch_nrdp` class:

##### `nrdp_token`
This token must match the same one used by nrdp on your nagios server.
You should certainly set it in hiera.

##### `nagios_server`
This is the server address put into the extra twitch_nrdp scripts. You
should also certainly set this in hiera.

##### `nagios_staging_server`
This is the staging server address put into the extra twitch_nrdp script. You may
set this in hiera, but it is not required. NRDP checks will also go to this host.

##### `nrdp_user`
This is the username with which nrdp checks are performed. Defaults to `nagios`

##### `base_dir`
The directory where the NRDP client will be installed. Defaults to `/usr/local/nrdp`.

##### more?
Several other optional parameters can be passed in. Check out the `params.pp` file.

#### These parameters can be passed to the `twitch_nrdp::check` define:

##### `name` (required)
The name you pass in is only used for identification.
Something that easily identifies this check is recommend.

##### `service_name` (required)
This is the name of the service that is reported to Nagios.

##### `command` (required)
The command to run. See examples above for the types of things you should put here.

##### `timeout`
How long we should wait for the command to complete. Default: 30 seconds.

##### `ensure`  
Defaults to `present`. Passing `absent` will cause the check to be removed.

##### `interval`
How often, in minutes, you want to fire this check.
Valid values are 1-60

##### `retry_interval`
How often, in minutes, you want to fire this check after the service reports a problem.
This is only honored until we get to the `retry` count (below).
Valid values are 1-60

##### `retry`
How many times we want to retry this service check before reporting a problem to Nagios.
Valid values are 1-60
