# This code came from
# http://stackoverflow.com/questions/2281850/timeout-function-if-it-takes-too-long-to-finish

import signal

class Timeout(object):
    def __init__(self, seconds, err_msg='Timeout'):
        self.seconds = seconds
        self.err_msg = err_msg
    def handle_timeout(self, signum, frame):
        raise TimeoutError(self.err_msg)
    def __enter__(self):
        signal.signal(signal.SIGALRM, self.handle_timeout)
        signal.alarm(self.seconds)
    def __exit__(self, type, value, traceback):
        signal.alarm(0)


class TimeoutError(Exception):
    pass
