# Instantiate a NRDP service check.
# This happens by putting a yaml file with check data
# into the checks.d folder.

define twitch_nrdp::check (
  $ensure         = present,
  $service_name   = $name,
  $command        = undef,
  $cmd_timeout    = 30,
  $interval       = 5,
  $retry          = 3,
  $retry_interval = 2,
  $options        = {},
) {
  if $ensure == present {
    include twitch_nrdp
    $base_dir = $twitch_nrdp::base_dir
    $nrdp_user = $twitch_nrdp::nrdp_user
    $svcfile = "${base_dir}/checks.d/${service_name}"

    validate_string($service_name,$nrdp_user,$command)
    validate_integer($cmd_timeout,120,1)
    validate_integer($interval,60,1)
    validate_integer($retry_interval,60,1)
    validate_integer($retry,60,1)
    validate_hash($options)

    file { $svcfile:
      ensure  => 'present',
      owner   => 'nobody',
      group   => 'nogroup',
      mode    => '0644',
      content => template('twitch_nrdp/nrdp_service.yaml'),
    }
  }
}
