# Pulls in checks defined in hiera; multiple different ways.
#
class twitch_nrdp::checks {
  require twitch_nrdp
  $passive_checks  = hiera_array('twitch_nrdp::checks',undef)
  $active_checks   = hiera_array('twitch_nrdp::active_checks',undef)
  $check_commands  = hiera_hash('twitch_nrdp::check_commands',{})
  $active_commands = hiera_hash('twitch_nrdp::active_check_commands',{})

  # This allows you to realize passive checks from hiera.
  # Add a variable to hiera like this to realize checks:
  # twitch_nrdp::checks:
  #   - check_name_here
  #   - another_check_here
  if $passive_checks {
    realize(Twitch_nrdp::Check[$passive_checks])
  }

  # This allows you to add realize checks from hiera.
  # Add a variable to hiera like this to realize checks:
  # twitch_nrdp::active_checks:
  #   - check_name_here
  #   - another_check_here
  if $active_checks {
    realize(Twitch_nrdp::Active_check[$active_checks])
  }

  # This allows you to create complete checks in hiera without
  # using or realizing anything in a manifest.
  # twitch_nrdp::check_commands:
  #   'link_aggregation':
  #     command: check_bond
  #     interval: 1
  #   'gatekeeper'
  #     command: 'check_gatekeeper.py'
  #     options:
  #       contact_groups: gatekeeper_contacts,vidops_pagerduty
  if !empty($check_commands) {
    create_resources(twitch_nrdp::check, $check_commands)
  }

  # This allows you to create complete passive checks in hiera.
  # Similar to above.
  if !empty($active_commands) {
    create_resources(twitch_nrdp::active_check, $active_commands)
  }
}
