# DO NOT ADD THINGS TO THIS FILE. thanks!
#
class twitch_nrdp::commands (
  $nrdp_load                     = $twitch_nrdp::nrdp_load,
  $nrdp_mem                      = $twitch_nrdp::nrdp_mem,
  $nrdp_zombies                  = $twitch_nrdp::nrdp_zombies,
  $nrdp_proc                     = $twitch_nrdp::nrdp_proc,
  $nrdp_disk                     = $twitch_nrdp::nrdp_disk,
  $nrdp_daemontools              = $twitch_nrdp::nrdp_daemontools,
  $nrdp_haproxy                  = $twitch_nrdp::nrdp_haproxy,
  $nrdp_link_aggregation_command = $twitch_nrdp::nrdp_link_aggregation_command,
) inherits twitch_nrdp {
  @twitch_nrdp::check { 'check_rotate_tls_session_keys':
    service_name => 'check_rotate_tls_session_keys',
    command      => '/usr/local/monitor_scripts/check_rotate_tls_session_keys.py',
  }
  @twitch_nrdp::check { 'check_usher_mem_usage':
    service_name => 'usher memory usage',
    command      => "/usr/lib/nagios/plugins/check_procs ${nrdp_proc}",
  }
  @twitch_nrdp::check{ 'check_memcached':
    service_name => 'memcached',
    command      => "check_memcached.pl -H 127.0.0.1 -p 11211 -T '>3,>5' -R '<60,<30' -U '>95,>98' -a curr_connections,evictions -w ~,~ -c ~,~ -f -A 'utilization,hitrate,response_time,curr_connections,evictions,cmd_set,bytes_written,curr_items,uptime,rusage_system,get_hits,total_connections,get_misses,bytes,time,connection_structures,total_items,limit_maxbytes,rusage_user,cmd_get,bytes_read,threads,rusage_user_ms,rusage_system_ms,cas_hits,conn_yields,incr_misses,decr_misses,delete_misses,incr_hits,decr_hits,delete_hits,cas_badval,cas_misses,cmd_flush,listen_disabled_num,accepting_conns,pointer_size,pid'",
    interval     => 5,
  }
  @twitch_nrdp::check { 'check_sandstorm_agent':
    service_name   => 'sandstorm-secret-health',
    command        => '/usr/local/monitor_scripts/check_sandstorm_agent',
    cmd_timeout    => 50,
    interval       => 10,
    retry_interval => 5,
    retry          => 3,
  }
  @twitch_nrdp::check { 'check_sandstorm_agent_ops':
    service_name   => 'sandstorm-agent-ops',
    command        => '/usr/local/monitor_scripts/check_sandstorm_agent -m ops',
    interval       => 10,
    retry_interval => 5,
    retry          => 3,
  }
  @twitch_nrdp::check { 'repmgr_state':
    service_name => 'repmgr_state',
    command      => 'sudo -u postgres /usr/local/monitor_scripts/repmgr_state.py',
    interval     => 3,
    retry        => 1,
  }
  @twitch_nrdp::check { 'check_server_status_consul':
    service_name => 'server-status',
    command      => '/usr/local/monitor_scripts/check_consul_enabled.sh',
    interval     => 1,
    retry        => 1,
  }
  @twitch_nrdp::check { 'check_aes':
    service_name => 'aes-enabled',
    command      => '/usr/local/monitor_scripts/check_aes.py',
    interval     => 10,
    retry        => 1,
    options      => {
      'use' => 'passive-service-nonotify'
    },
  }
  @twitch_nrdp::check { 'check_haproxy_connection_ratio':
    service_name => 'haproxy_connection_ratio',
    command      => "/usr/local/monitor_scripts/check_haproxy_connection_ratio.py ${nrdp_haproxy}",
    interval     => 2,
    retry        => 2,
  }
}
