# This module will install a custom send_nrdp.py - excitng, isn't it?
# This script allows you to send nrdp service checks to a nagios server.
# The two helper scripts are custom for this module. They allow us to
# pre-fill the hostname and token. Check-on my friends!

class twitch_nrdp (
  $ensure                = present,
  $nrdp_token            = $twitch_nrdp::params::nrdp_token,
  $nagios_server         = $twitch_nrdp::params::nagios_server,
  $nagios_staging_server = $twitch_nrdp::params::nagios_staging_server,
  $nrdp_user             = $twitch_nrdp::params::nrdp_user,
  $base_dir              = $twitch_nrdp::params::base_dir,
  $nrdp_load             = $twitch_nrdp::params::nrdp_load,
  $nrdp_mem              = $twitch_nrdp::params::nrdp_mem,
  $nrdp_zombies          = $twitch_nrdp::params::nrdp_zombies,
  $nrdp_proc             = $twitch_nrdp::params::nrdp_proc,
  $nrdp_disk             = $twitch_nrdp::params::nrdp_disk,
  $nrdp_daemontools      = $twitch_nrdp::params::nrdp_daemontools,
  $nrdp_haproxy          = $twitch_nrdp::params::nrdp_haproxy,
  $ncgp_team             = $twitch_nrdp::params::ncgp_team,
  $nagios_hostgroups     = [],
  $nrdp_host_params      = {},
) inherits twitch_nrdp::params {
  if $ensure == 'present' {
    # This is only temporary to pull in the nagios user/group.
    require twitch_nrpe
    include twitch_nrdp::commands
    include twitch_nrdp::checks
    $dir_ensure = directory
  } else {
    $dir_ensure = absent
  }

  # Only send production hosts to production nagios
  # default to staging
  $env = pick($::twitch_environment, $twitch_environment, 'staging')

  $nrdp_host = $env ? {
    /^canary/  => $nagios_server,
    production => $nagios_server,
    default    => $nagios_staging_server,
  }

  # The correct PATH env allows commands to work without absolute paths.
  $envpath = 'PATH=/bin:/usr/bin:/usr/local/monitor_scripts:/usr/lib/twitch/monitoring-plugins:/usr/lib/twitch/monitoring-scripts:/usr/lib/nagios/plugins:/usr/local/bin:/sbin:/usr/sbin'

  class { '::twitch_nrdp::service': }

  $nrdp_run_once = "${envpath} python twitch_nrdp.py -u https://${nrdp_host}/nrdp/"

  file { $base_dir:
    ensure  => $dir_ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    recurse => true,
    force   => true,
    purge   => true,
  }
  file { "${base_dir}/checkcache":
    ensure => $dir_ensure,
    owner  => $nrdp_user,
    group  => $nrdp_user,
    mode   => '0755',
  }
  file { "${base_dir}/checks.d":
    ensure  => $dir_ensure,
    owner   => 'nobody',
    group   => 'nogroup',
    mode    => '0755',
    purge   => true,
    recurse => true,
    force   => true,
  }
  file { "${base_dir}/token.txt":
    ensure  => $ensure,
    owner   => $nrdp_user,
    mode    => '0600',
    content => $nrdp_token,
  }
  file { "${base_dir}/timeout.py":
    ensure => $ensure,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => 'puppet:///modules/twitch_nrdp/timeout.py',
  }
  file { "${base_dir}/twitch_nrdp.py":
    ensure => $ensure,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => 'puppet:///modules/twitch_nrdp/twitch_nrdp.py',
  }
  file { '/usr/local/bin/nrdp_run_once':
    ensure  => $ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    content => "#!/bin/bash\n# puppet wuz here.\n\npushd ${base_dir}\n${nrdp_run_once}\npopd\n",
  }
}
