# Set parameters for NRDP installation.

class twitch_nrdp::params {
  # This is just something to fill in the blanks.
  # It matches the default token in puppet-ci/twitch_nagios
  $nrdp_token            = '64c147c4ba4a97728d1a3b00c272ca0d'
  $nagios_server         = 'video-nagios.internal.justin.tv'
  $nagios_staging_server = 'video-nagios-staging.internal.justin.tv'
  $nrdp_user             = 'nagios'
  $base_dir              = '/usr/local/nrdp'
  $nrdp_load             = '-w 2.55,2.55 -c 2.80,2.80'
  $nrdp_mem              = '-w 80:50 -c 90:70'
  $nrdp_zombies          = '-w 5 -c 10'
  $nrdp_proc             = '-w 5 -c 10'
  $nrdp_disk             = '-w 25% -c 15% -r /dev/ -C -w 50% -c 35% -p /boot'
  $nrdp_daemontools      = ''
  $nrdp_haproxy          = ''
  $nrdp_link_aggregation = hiera('twitch_link_aggregation::method')
  $ncgp_team             = $::twitch_team

  case $nrdp_link_aggregation {
    'bond': { $nrdp_link_aggregation_command = 'sudo /usr/local/monitor_scripts/check_bond' }
    default: { $nrdp_link_aggregation_command = '/usr/local/monitor_scripts/check_team.py' }
  }

}
