# Sets up nrdp passive check agent service.
#
class twitch_nrdp::service inherits twitch_nrdp {
  if $twitch_nrdp::ensure == present {
    $svc_ensure  = running
    $svc_enable  = true
    $unit_notify = Service['nrdp']
    $svc_require = [
      Twitch_systemd::Unit_file['nrdp.service'],
      Class['::systemd'],
    ]
    $svc_subscrib = File[
      "${::twitch_nrdp::base_dir}/twitch_nrdp.py",
      "${::twitch_nrdp::base_dir}/token.txt",
      "${::twitch_nrdp::base_dir}/timeout.py"
    ]
  } else {
    $svc_ensure   = stopped
    $svc_enable   = false
    $unit_require = Service['nrdp']
  }

  if str2bool($::systemd) {
    twitch_systemd::unit_file { 'nrdp.service':
      ensure  => $::twitch_nrdp::ensure,
      content => template('twitch_nrdp/nrdp.service.erb'),
      notify  => $unit_notify,
      require => $unit_require,
    }
    service { 'nrdp':
      ensure     => $svc_ensure,
      enable     => $svc_enable,
      hasrestart => true,
      hasstatus  => true,
      subscribe  => $svc_subscrib,
      require    => $svc_require,
    }
  } else {
    daemontools::supervise { 'nrdp':
      ensure         => $::twitch_nrdp::ensure,
      daemon_dir     => '/var/lib/service',
      daemon         => 'python twitch_nrdp.py',
      options        => "--auto --monitor ${::twitch_nrdp::urls} 2>&1",
      predaemon      => [ "export ${::twitch_nrdp::envpath}" ],
      wd             => $::twitch_nrdp::base_dir,
      user           => $::twitch_nrdp::nrdp_user,
      syslog         => 'local3',
      manage_service => true,
      subscribe      => $svc_subscrib,
    }
  }
}
