# Installs NRPE commands into /etc/nagios/nrpe.d directory.

class twitch_nrpe::commands (
) inherits twitch_nrpe {

  nrpe::command { 'restart-edgeviewcounter':
    ensure  => present,
    command => '/usr/local/nagios/jtv/restart-edgeviewcounter.sh',
  }

  nrpe::command { 'check_proc_statsite':
    ensure  => present,
    command => 'check_procs -C statsite -a /etc/statsite/config -c 1:1',
  }

  nrpe::command { 'check_aes':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_aes.py',
  }

  nrpe::command { 'check_ipmi_sensor':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_ipmi_sensor -v',
  }

  nrpe::command { 'check_users':
    ensure  => present,
    command => 'check_users -w 10 -c 15',
  }

  nrpe::command { 'check_load':
    ensure  => present,
    command => "check_load -r ${twitch_nrpe::nrpe_load}",
  }

  nrpe::command { 'check_hda1':
    ensure  => present,
    command => "check_disk ${twitch_nrpe::nrpe_disk} -i /srv/node/.* -i /snap",
  }

  nrpe::command { 'check_shm':
    ensure  => present,
    command => 'check_disk -w 20% -c 10% -p /run/shm',
  }

  nrpe::command { 'check_disk_args':
    ensure  => present,
    command => 'check_disk $ARG1$ -i /srv/node/.*',
  }

  nrpe::command { 'check_zombie_procs':
    ensure  => present,
    command => "check_procs ${twitch_nrpe::nrpe_zombies} -s Z",
  }

  nrpe::command { 'check_total_procs':
    ensure  => present,
    command => 'check_procs -w 7000 -c 10000',
  }

  nrpe::command { 'check_proc_noarg':
    ensure  => present,
    command => "check_procs ${twitch_nrpe::nrpe_proc}",
  }

  nrpe::command { 'check_ntp':
    ensure  => present,
    command => '/usr/local/monitor_scripts/check_chrony_health',
  }

  nrpe::command { 'check_cron':
    ensure  => present,
    command => 'check_procs  -C cron -u root -c 1:'
  }

  nrpe::command { 'check_mem':
    ensure  => present,
    command => "/usr/local/nagios/jtv/check_memswap.pl ${twitch_nrpe::nrpe_mem}",
  }

  nrpe::command { 'check_megaraid':
    ensure  => present,
    command => "/usr/local/nagios/jtv/check_megaraid_sas ${twitch_nrpe::nrpe_megaraid}",
  }

  nrpe::command { 'check_local_memcached':
    ensure  => present,
    command => 'check_tcp -H 127.0.0.1 -p 11211 -w 2.0 -c 5.0',
  }

  nrpe::command { 'check_archives':
    ensure  => present,
    command => 'find /usr/local/WowzaMediaServerPro/wowza1/content -name \'*.flv\' -size +512c -cmin +60 | wc -l | python -c \'c=int(raw_input()); print c; ((c>5) and exit(2)); ((c>2) and exit(1))\'',
  }

  nrpe::command { 'check_dirty':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_md5.sh --file /etc/facter/facts.d/clean.txt --md5 c60d4a11364aad4487ce2e8648cff465',
  }

  nrpe::command { 'check_proc':
    ensure  => present,
    command => 'check_procs $ARG1$',
  }

  nrpe::command { 'check_proc_comm_arg':
    ensure  => present,
    command => 'check_procs -C $ARG1$ -a $ARG2$ -w $ARG3$ -c $ARG4$',
  }

  nrpe::command { 'check_proc_comm_arg_plus_user_for_arg':
    ensure  => present,
    command => 'check_procs -a "$ARG1$" -u $ARG2$ -w $ARG3$ -c $ARG4$',
  }

  nrpe::command { 'check_daemontools':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_daemontools $ARG1$',
  }

  nrpe::command { 'check_bird_running':
    ensure  => present,
    command => "/usr/local/nagios/jtv/check_daemontools_services ${twitch_nrpe::nrpe_bird_name}",
  }

  nrpe::command { 'check_daemontools_specify':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_daemontools_specify $ARG1$',
  }

  nrpe::command { 'check_openmanage':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_openmanage -s $ARG1$',
  }

  nrpe::command { 'check_mgmond':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_mgmond.sh',
  }

  nrpe::command { 'check_filesize_in_dir':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_filesize.py -s $ARG1$ -d $ARG2$',
  }

  nrpe::command { 'check_rebouncer':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_rebouncer.sh $ARG1$',
  }

  nrpe::command { 'check_reducer':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_reducer.py $ARG1$',
  }

  nrpe::command { 'check_bond':
    ensure  => present,
    sudo    => true,
    command => '/usr/local/nagios/jtv/check_bond',
  }

  nrpe::command { 'check_nic_utilization':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_nic_utilization',
  }

  nrpe::command { 'check_mcelog':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_mcelog.sh',
  }

  nrpe::command { 'check_uptime':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_uptime.py $ARG1$',
  }

  nrpe::command { 'check_raid':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_raid.pl $ARG1$',
  }

  nrpe::command { 'check_s3':
    ensure  => present,
    command => '/home/jtv/s3proxy/nagios_s3_check.py $ARG1$',
  }

  nrpe::command { 'check_jbods':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_jbods.py',
  }

  nrpe::command { 'check_jax_topchans':
    ensure  => present,
    command => '/home/jtv/jax_deploy/current/bin/check_topchans -backend=$ARG1$ -backend=localhost:6062',
  }

  nrpe::command { 'check_file_count':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_file_count.py -w $ARG1$ -c $ARG2$ -d $ARG3$',
  }

  nrpe::command { 'check_interface_has_ip':
    ensure  => present,
    command => '/usr/local/nagios/jtv/interface_with_ip.py --interface $ARG1$ --ip $ARG2$',
  }

  nrpe::command { 'check_github_backups':
    ensure  => present,
    command => "find /mnt/media/backup/ghe -ctime -1 -size +2G >/dev/null 2>&1 && echo 'OK: Backups ran today' || (echo 'CRITICAL: No recent backups exist'; exit 2)"
  }

  nrpe::command { 'memcached_stats':
    ensure  => present,
    command => '/usr/local/nagios/jtv/memcached_stats.py',
  }

  nrpe::command { 'check_edge_viewcount':
    ensure  => present,
    command => '/opt/twitch/edgeviewcounter/current/nagios/edgeviewcounter',
  }

  nrpe::command { 'check_daemontools_noarg':
    ensure  => present,
    command => "/usr/local/nagios/jtv/check_daemontools ${twitch_nrpe::nrpe_daemontools}",
  }

  nrpe::command { 'consul_master':
    ensure  => present,
    command => '/usr/bin/consul-alert-server',
  }

  nrpe::command { 'check_sandstorm_agent':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_sandstorm_agent',
  }

  nrpe::command { 'check_sandstorm_agent_ops':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_sandstorm_agent -m ops',
  }

  nrpe::command { 'check_hwparserino_app':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_hwparserino -s app',
  }

  nrpe::command { 'check_backup_device42_time':
    ensure  => present,
    command => 'check_file_age -w 86400 -c 129600 -f /mnt/postgres_backup/device42',
  }

  nrpe::command { 'check_openvpn_status_log':
    ensure  => present,
    sudo    => true,
    command => 'check_file_age -w 90 -c 120 -f /etc/openvpn/openvpn-status.log',
  }

  nrpe::command { 'check_tcp':
    ensure  => present,
    command => 'check_tcp -H $ARG1$ -p $ARG2$ -w $ARG3$ -c $ARG4$',
  }

  nrpe::command { 'check_tcp_consul':
    ensure  => present,
    command => 'check_tcp -H 127.0.0.1 -p 8500 -w 3 -c 6',
  }

  nrpe::command { 'check_consul_members':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_consul_member.py',
  }
  nrpe::command { 'check_consul_self_pop':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_consul_self_pop.py',
  }

  nrpe::command { 'check_telegraph_procs':
    ensure  => present,
    command => 'check_procs -c 4:8 -C telegraph',
  }

  nrpe::command { 'check_rotate_tls_session_keys':
    ensure  => present,
    command => '/usr/local/monitor_scripts/check_rotate_tls_session_keys.py',
  }

  nrpe::command { 'check_puppet':
    ensure  => present,
    sudo    => true,
    command => '/usr/local/monitor_scripts/check-puppet-tng -w 40m -c 75m -level events.failure:0 -level resources.failed:0 -level resources.failed_to_restart:0',
  }

  nrpe::command { 'check_team':
    ensure  => present,
    command => '/usr/local/nagios/jtv/check_team.py',
  }

  nrpe::command { 'repmgr_state':
    ensure  => present,
    command => '/usr/local/nagios/jtv/repmgr_state.py',
  }
  nrpe::command { 'check_openvpn_license':
    ensure  => present,
    command => '/usr/local/monitor_scripts/openvpnas_license_expiry.py -w 28: -c 7: -v',
    sudo    => true,
  }

}
