class twitch_nrpe::config () inherits twitch_nrpe {

  file { '/etc/init.d/nrpe':
    ensure => absent,
  }

  file { '/usr/local/nagios':
    ensure => directory,
    owner  => 'nagios',
    group  => 'nagios',
    mode   => '0755',
  }

  include twitch_monitor_scripts

  # scripts are now located in the twitch_monitor_scripts class.
  # creating a symlink for compatibility
  file { '/usr/local/nagios/jtv':
    ensure  => 'link',
    force   => true,
    target  => '/usr/local/monitor_scripts',
    require => Class['twitch_monitor_scripts'],
  }

  file { '/etc/init.d/nagios-nrpe-server':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => 'puppet:///modules/twitch_nrpe/nagios-nrpe-server.init',
  }
}
