# Installs and configures NRPE and service checks on a host.

class twitch_nrpe (
  $dont_blame_nrpe        = $twitch_nrpe::params::dont_blame_nrpe,
  $allowed_nagios_servers = $twitch_nrpe::params::allowed_nagios_servers,
  $nrpe_megaraid          = $twitch_nrpe::params::nrpe_megaraid,
  $nrpe_load              = $twitch_nrpe::params::nrpe_load,
  $nrpe_mem               = $twitch_nrpe::params::nrpe_mem,
  $nrpe_zombies           = $twitch_nrpe::params::nrpe_zombies,
  $nrpe_proc              = $twitch_nrpe::params::nrpe_proc,
  $nrpe_disk              = $twitch_nrpe::params::nrpe_disk,
  $nrpe_daemontools       = $twitch_nrpe::params::nrpe_daemontools,
  $nrpe_bird_name         = $twitch_nrpe::params::nrpe_bird_name,
) inherits twitch_nrpe::params {

  anchor { 'twitch_nrpe::begin': } ->
  class { 'twitch_nrpe::install': } ~>
  class { 'twitch_nrpe::config': } ~>
  class { 'twitch_nrpe::commands': } ~>
  class { 'twitch_nrpe::service': } ->
  anchor { 'twitch_nrpe::end': }

}
