# Installs nrpe type components
class twitch_nrpe::install () inherits twitch_nrpe {

  $client_packages = ['nagios-plugins', 'nagios-plugins-basic', 'nagios-nrpe-server']
  package { $client_packages:
    ensure          => present,
    install_options => ['--no-install-recommends'],
  }

  # Wrapper for running nrdp/nrdc a single time on a host
  file { '/usr/local/bin/run_nagios_passive_once':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => 'puppet:///modules/twitch_nrpe/run_nagios_passive_once',
  }

}
