# NRPE Parameters
class twitch_nrpe::params {
  $dont_blame_nrpe    = '1'
  # Client config
  $allowed_nagios_servers    = [
    '127.0.0.1',       # so nagios can check itself.
    '10.1.98.155',     # nagios clean
    '10.197.219.184',  # central-nagios
    '10.197.219.185',  # central-nagios-staging
    '10.192.67.253',   # systems-nagios
    '10.192.67.137',   # web-nagios (old)
    '10.194.199.198',  # web-nagios (new)
    '10.192.66.110',   # science-nagios-69160fac
  ]
  $nrpe_enable       = true
  $nrpe_megaraid     = ''

  $nrpe_load         = '-w 2.55,2.55 -c 2.80,2.80'
  $nrpe_mem          = '-w 80:50 -c 90:70'
  $nrpe_zombies      = '-w 5 -c 10'
  $nrpe_proc         = '-w 5 -c 10'
  $nrpe_disk         = '-w 25% -c 15% -r /dev/ -C -w 50% -c 35% -p /boot'
  $nrpe_daemontools  = ''
  $nrpe_bird_name    = 'bird'
}
