# NSCA client installation
class twitch_nsca::nsca_client (
  $nagios_servers    = $twitch_clean_nagios::nagios_servers,
) inherits twitch_nsca::params {

  $client_packages = [$nsca_package]

  package { $client_packages:
    ensure => present,
    install_options => ['--no-install-recommends'],
  }

  file { '/etc/send_nsca.cfg':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/send_nsca.cfg.erb"),
    require => Package[$nsca_package],
  }

}
