# NSCA server Installation
class twitch_nsca::nsca_server inherits twitch_nsca::params {

  package { 'nsca':
    ensure => 'installed',
  }

  service { 'nsca':
    ensure    => 'running',
    enable    => true,
    hasstatus => false,
  }

  file { '/etc/nsca.cfg':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/nsca.cfg.erb"),
    require => Package['nsca'],
    notify  => Service['nsca'],
  }

}
