# Setup anycast for NSD. Used by dns-auth (bare metal)
# No anycast health enforcer.
#
class twitch_nsd::anycast (
  $community = undef,
  $ifacename = undef,
  $queries   = 'ntp.internal.justin.tv,justin.tv',
) {
  include twitch_nsd
  $ipaddress = $twitch_nsd::anycast_ipaddress

  if !$::disable_anycast and $ipaddress {
    validate_integer($community)
    if $ifacename == '' or $ifacename == undef {
      include twitch_anycast_health_enforcer::monitoring
      # Cache servers (pop-masters) have a health enforcer.
      twitch_anycast_health_enforcer::service { 'authdns':
        interval   => '2s',
        window     => 2,
        threshold  => 1,
        addresses  => [$ipaddress],
        community  => $community,
        flap_limit => -1,
        checks     => {
          '/usr/lib/nagios/plugins/check_dns -s localhost -H 127.0.0.1 -t 1' => {
            type    => 'cmd',
            timeout => '2s',
          },
        },
      }
    } else {
      # dns-auth does not use a health enforcer, so just call bird.
      bird::service { $ifacename:
        ipaddress => $ipaddress,
        community => $community,
        auto      => true,
      }
    }
  }

  if $ipaddress {
    include bird::monitoring
    twitch_servicecheck::passive { 'NSD and Anycast':
      command => "dns-anycast -q ${queries} -a ${ipaddress} -w 500ms -c 1s",
      options => {
        notes_url => 'https://wiki.twitch.com/display/SYS/dns-anycast+check',
      },
    }
  }
}
