# Twitch nsd class
class twitch_nsd (
  $external_masters    = undef,
  $internal_masters    = undef,
  $external_key        = undef,
  $internal_key        = undef,
  $anycast_ipaddress   = undef,
  $logfile_location    = $twitch_nsd::params::logfile_location,
  $nsd_env             = $twitch_nsd::params::nsd_env,
  $external_zones      = $twitch_nsd::params::external_zones,
  $internal_zones      = $twitch_nsd::params::internal_zones,
  $external_dns_slaves = $twitch_nsd::params::external_dns_slaves,
  $nsd_daemon_options  = $twitch_nsd::params::nsd_daemon_options,
  $listen_addresses    = undef,
  $verbosity           = $twitch_nsd::params::verbosity,
) inherits twitch_nsd::params {
  $default_addresses   = [$anycast_ipaddress, $::ipaddress_primary, '127.0.0.1']
  $_listen_addresses   = delete_undef_values(pick($listen_addresses, $default_addresses))

  # Setup filebeat
  include twitch_nsd::logging
  include twitch_nsd::anycast
  ensure_resource('twitch_diamond::collector', 'NsdCollector', {
    enable => true,
    source => true,
  })
  ensure_resource('twitch_diamond::collector', 'UDPCollector', {
    enable  => true,
    options => {
      allowed_names => '',
    },
  })

  class { '::nsd':
    service_manage => false,
    options        => merge($nsd_daemon_options, {
      'ip-address' => $_listen_addresses,
      'logfile'    => $logfile_location,
      'verbosity'  => $verbosity,
    }),
  }

  # Include remote so nsd-control is always there
  class { 'nsd::remote':
    interface => '127.0.0.1',
  }

  # opensource module does not gracefully reload/reconfig running service
  service { 'nsd':
    ensure    => 'running',
    enable    => true,
    hasstatus => true,
    restart   => 'nsd-control reconfig',
    require   => [Class['nsd'],Class['nsd::remote']],
    subscribe => Class['nsd::config'],
  }
}
