# This manifest creates a NSD config that slaves only our internal zones from Infoblox.
# Internal zones includes all external zones without internal views.
# There are no external clients for these zones and notifies are sent to internal servers.
#
class twitch_nsd::internal_infoblox_slave inherits twitch_nsd {

  # create view config snippets for slaving with keys, etc
  twitch_nsd::slave { $twitch_nsd::internal_masters:
    master_key => $twitch_nsd::internal_key,
    type       => 'internal-xfers',
  }
  twitch_nsd::slave { $twitch_nsd::external_masters:
    master_key => $twitch_nsd::external_key,
    type       => 'external-xfers',
  }

  # we can't have duplicate zones in 1 config, so:
  # 1. get all external view zones
  # 2. delete all matching internal zones
  # 3. use internal zones, and any non-duplicate external zones
  $external_zones = delete($twitch_nsd::external_zones,$twitch_nsd::internal_zones)

  # Setup external zones (minus zones with an internal view)
  twitch_nsd::zone { $external_zones:
    options => {
      'include-pattern' => prefix($twitch_nsd::external_masters,'from_master_'),
    }
  }

  # Setup internal zones.
  twitch_nsd::zone { $twitch_nsd::internal_zones:
    options => {
      'include-pattern' => prefix($twitch_nsd::internal_masters,'from_master_'),
    }
  }

  # Add health checks to make sure replication stays current.
  # https://jira.twitch.com/browse/SYS-13747
  twitch_servicecheck::passive { 'NSD Zone Replication':
    command        => join([
      'dns-anycast',
      '--server 127.0.0.1:53',
      '--recheck "$SERVICEPERFDATA$"',
      '--zone justin.tv:100:,10.in-addr.arpa:100:,ttvnw.net:100:',
    ], ' '),
    interval       => 5,
    retry_interval => 5,
    retry          => 2,
  }
}
