# Setup filebeat for NSD
class twitch_nsd::logging (
){

  video_cloudwatch::logfile { 'nsd':
    file_path        => '/var/log/nsd.log',
    timestamp_format => '%Y-%m-%d %H:%M:%S.%f',
  }

  exec { 'nsd - set verbosity for running instances':
    command => "/usr/sbin/nsd-control verbosity ${::twitch_nsd::verbosity}",
    unless  => "/usr/sbin/nsd-control status | /bin/grep 'verbosity:\s${::twitch_nsd::verbosity}$'",
  }

}
