# twitch_nsd parameters
class twitch_nsd::params {
  $logfile_location    = '/var/log/nsd.log'
  $zones               = hiera('twitch_dns_zones')
  $external_zones      = $zones['external']
  $internal_zones      = $zones['internal']
  $nsd_env             = pick($twitch_environment, $::twitch_environment, 'production')
  # Set default verbosity level. Same as nsd default, 0.
  $verbosity = '0'
  # external provider IP addresses (should not change often/at all)
  $external_dns_slaves = [
    '204.13.249.65', # dyn
    '208.78.68.65',  # dyn
    '72.13.32.98',   # verisign
    '72.13.32.99',   # verisign
    '69.58.186.98',  # verisign
    '69.58.186.99',  # verisign
    '54.217.202.161',  # Ultradns notify
    '107.21.214.87',  # Ultradn notify
    '54.245.253.13',  # Ultradns notify
  ]

  # common daemon options
  $nsd_daemon_options  = {
    'server-count'   => clamp(1, $::processorcount / 2, $::processorcount),
    'do-ip6'         => 'no',
    'database'       => '/var/lib/nsd/nsd.db',
    'ip-transparent' => 'yes',
    'tcp-count'      => 100,
  }

}
