# private API to couple slave pattern with key
define twitch_nsd::slave(
  $master_key,
  $type,
  $master             = $name,
  $algorithm          = 'md5',
  $outgoing_interface = $::ipaddress_primary,
) {
  ensure_resource('nsd::key', $type, {secret => $master_key, algorithm => $algorithm})

  nsd::pattern::slave { "zone_${name}_master":
    master_server => $master,
    master_key    => $type,
    transfer_mode => '',
    options       => {
      'allow-notify'       => "${master} NOKEY",
      'outgoing-interface' => $outgoing_interface,
    },
  }
}
