# private API to create simple upstream for a slave.
#
define twitch_nsd::upstream (
  $master_key    = 'NOKEY',
  $notify_key    = 'NOKEY',
  $transfer_mode = 'AXFR',
) {

  nsd::pattern::slave { "dns_upstream_${name}":
    master_server => $name,
    master_key    => $master_key,
    transfer_mode => $transfer_mode,
    # Allow anyone to notify.
    options       => { 'allow-notify' => "10.0.0.0/8 ${notify_key}" },
  }
}
