# twitch_ntp

#### Table of Contents
<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
## Overview

- [Overview](#overview)
- [Module Description](#module-description)
- [Setup](#setup)
  - [What twitch_ntp affects](#what-twitch_ntp-affects)
  - [Beginning with twitch_ntp](#beginning-with-twitch_ntp)
- [Usage](#usage)
  - [Class twitch_ntp parameters](#class-twitch_ntp-parameters)
- [Reference](#reference)
  - [Classes](#classes)
  - [Defines](#defines)
- [Limitations](#limitations)
- [Contribution](#contribution)
  - [Making Changes](#making-changes)
  - [Pull Requests](#pull-requests)
  - [Code Reviews](#code-reviews)
- [Release Notes/Contributors/Etc **Optional**](#release-notescontributorsetc-optional)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->
## Overview

Manages the ntp client

## Module Description

Manages the ntp client

## Setup

### What twitch_ntp affects

* chrony package and service
* /etc/chrony.conf
* /etc/cron.daily/syncrtc
* /etc/network/if-up.d/chrony

### Beginning with twitch_ntp

## Usage

```
include twitch_ntp

```

### Class twitch_ntp parameters

* twitch_ntp
  * twitch_repo_testing
  * servers
  * pools
  * version
  * chrony_config
  * max_update_skew
  * queryhosts
  * master_peers
  * master
  * ntp_warn_sources
  * ntp_crit_sources

## Reference

### Classes

* twitch_ntp

### Defines
* none

## Limitations

## Contribution

### Making Changes

Contributions to this repository:

* need to be limited to what is described in [Module Description](#module-description).
  * Not doing so has created massive tech debt in the past, which lead to another massive cleanup still in progress (deprecation of the core module).
* should be reviewed via [Pull Requests](#pull-requests) before merging.
* must follow the [Code Contribution Guidelines].
* See the [Code Contribution Checklist] for a quick reference.
* Any changes outside of the scope should follow puppet best pratices and be included either by role or service module. e.g.

Add to classes in either environment or cluster in video-puppet/hiera_data
```
# environment/canary/video-tier1.yaml
---
classes:
  - twitch_random_service_modules
  - additional_module_1
  - additional_module_2
```
or

Add include in the service class
    edit video-tier1/manifests/init.pp or appropriate sub class in the module and include:
```
include additional_module_1
include additional_module_2
```

### Pull Requests
All pull requests must:
  - Have a description explaining the problem
  - Snippet of any output error
  - Snippet of any output showing the fixed results
  - Contain a link to a JIRA ticket
  - Have been linted:
   - `puppet-lint`
   - `flake8`
   - `puppet validate`
   - etc
  - Not contain lint errors. Run all new code through `puppet-lint`.

### Code Reviews

PR reviews require video core services approval before merging. If you need help finding a reviewer, ping the [#video-coreservices] Slack channel.

Contributions need to be limited to what is described in Module Description. Not doing so has created massive tech debt in the past, which lead to another massive cleanup still in progress (deprecation of the core module). Any changes outside of the scope should follow puppet best pratices and be included either by role or service module. e.g.

Add to classes in either environment or cluster in video-puppet/hiera_data
```
# environment/canary/video-tier1.yaml
---
classes:
  - twitch_random_service_modules
  - additional_module_1
  - additional_module_2
```
or

Add include in the service class
    edit video-tier1/manifests/init.pp or appropriate sub class in the module and include:
```
include additional_module_1
include additional_module_2
```

## Release Notes/Contributors/Etc **Optional**

[#video-coreservices]: https://twitch.slack.com/messages/CEVFAMMLH/
[Code Contribution Guidelines]: https://wiki.xarth.tv/display/VID/Puppet+Usage+Guidance+-+Video+Platform
[Code Contribution Checklist]: https://wiki.xarth.tv/display/VID/Puppet+Usage+Guidance+-+Video+Platform#PuppetUsageGuidanceVideoPlatform-GeneralGuidance
