# Wrapper to setup Chrony for justin.tv hosts and EC2 instances.
#
class twitch_ntp(
  $servers          = $twitch_ntp::params::servers,
  $pools            = $twitch_ntp::params::pools,
  $version          = $twitch_ntp::params::version,
  $chrony_config    = $twitch_ntp::params::chrony_config,
  $max_update_skew  = $twitch_ntp::params::max_update_skew,
  $queryhosts       = $twitch_ntp::params::queryhosts,
  $master_peers     = $twitch_ntp::params::master_peers,
  $master           = $twitch_ntp::params::master,
  $ntp_warn_sources = $twitch_ntp::params::ntp_warn_sources,
  $ntp_crit_sources = $twitch_ntp::params::ntp_crit_sources,
) inherits twitch_ntp::params {

  validate_array($servers,$pools,$queryhosts,$master_peers)
  validate_absolute_path($chrony_config)
  validate_string($version,$max_update_skew)
  validate_bool($master)

  include twitch_vars
  include twitch_timesyncd

  $_queryhosts = concat($::twitch_vars::twitch_networks, $queryhosts)

  twitch_systemd::unit_file { 'chrony.service':
    content => template("${module_name}/chrony.service.erb"),
    before  => Class['::chrony'],
  }

  file { '/etc/cron.daily/syncrtc':
    ensure => 'file',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => 'puppet:///modules/twitch_ntp/syncrtc.sh',
  }

  class { '::chrony':
    config             => $chrony_config,
    config_template    => 'twitch_ntp/chrony.conf.erb',
    package_ensure     => $version,
    package_name       => 'chrony',
    servers            => $servers,
    queryhosts         => $_queryhosts,
    service_manage     => true,
    service_enable     => true,
    service_ensure     => running,
    service_name       => 'chrony',
    chrony_password    => 'unset',
    config_keys_manage => false,
    require            => File['/etc/cron.daily/syncrtc'],
  }

  if $master {
    # This check only goes on ntp- master servers.
    twitch_servicecheck::passive { 'check-ntp-peers':
      command  => "/usr/local/monitor_scripts/check_chrony_health -w '${ntp_warn_sources}:' -c '${ntp_crit_sources}:'",
      interval => 3,
    }
  } else {
    # This isnt used/needed on masters.
    file { '/etc/network/if-up.d/chrony':
      ensure  => 'file',
      owner   => 'root',
      group   => 'root',
      mode    => '0755',
      source  => 'puppet:///modules/twitch_ntp/ifup.sh',
      before  => Class['::chrony'],
      require => Package['openssh-server'],
    }
  }
}
