# Twitch's time service defaults.
#
class twitch_ntp::params {
  # Clients get time from these servers.
  case $facts['ec2_metadata'] {
    undef: {
      $servers          = [] # do not set undef or the erb template complains.
      $pools            = [ 'ntp.internal.justin.tv' ]
    }
    default: {
      $servers          = [ '169.254.169.123' ]
      $pools            = [] # do not set undef or the erb template complains.
    }
  }
  $version          = 'installed'
  $chrony_config    = '/etc/chrony/chrony.conf'
  $max_update_skew  = '10'
  $queryhosts       = []
  # Masters peer with one-another. Avoid setting this on clients.
  $master_peers     = []
  $master           = false
  $ntp_warn_sources = 3
  $ntp_crit_sources = 2
}
