# Prism module parameters
class twitch_nydus::params {
  $ensure  = 'absent'

  $env    = pick($::twitch_environment, $twitch_environment, 'production')

  $port     = undef
  $tls_port = undef
  $internal_addr = undef

  $statsd_host = hiera('statsd_host', 'statsd.internal.justin.tv')
  $statsd_port = hiera('statsd_port', 8125)
  $statsd_addr = "${statsd_host}:${statsd_port}"
  $statsd_rate = 1

  $ssl_alg = 'rsa'

  $vitreous_url = 'http://vitreous-iris-staging.internal.justin.tv'

  $systemd_start_timeout_sec = '60'

  $binary = undef

  $memory_policy_interleave = true
}
