# Prism SSL certs / keys
define twitch_nydus::ssl (
  $sandstorm_key_prefix = undef,
  $alg_type             = 'rsa',
  $dir                  = undef,
  $user                 = undef,
) {
  validate_absolute_path($dir)
  validate_re($alg_type, '^(rsa|ecdsa|both)$', 'The value for alg_type must be either "rsa", "ecdsa", or "both"')
  validate_string($user)

  $restart_command = 'systemctl reload nydus'

  if $alg_type =~ /^(rsa|both)$/ {

    $rsa_cert_contents = join([
      "{{ key \"${sandstorm_key_prefix}/cert\" }}",
      "{{ key \"${sandstorm_key_prefix}/intermediate\" }}",
      "{{ key \"${sandstorm_key_prefix}/dhparam\" }}",
    ], "\n")

    twitch_ssl_certificate::certificate { "${name}_rsa_cert":
      cert_identifier      => "${name}_rsa_cert",
      cert_filesystem_path => "${dir}/${name}_rsa_cert.pem",
      cert_contents        => $rsa_cert_contents,
      cert_owner           => $user,
      cert_group           => 'ssl-cert',
      cert_mode            => '0640',
      cert_restart_cmd     => $restart_command,
      key_identifier       => "${name}_rsa_key",
      key_filesystem_path  => "${dir}/${name}_rsa_key.pem",
      key_contents         => "{{ key \"${sandstorm_key_prefix}/key\" }}",
      key_owner            => $user,
      key_group            => 'ssl-cert',
      key_mode             => '0640',
      key_restart_cmd      => $restart_command,
    }

  }

  if $alg_type =~ /^(ecdsa|both)$/ {

    $ecdsa_cert_contents = join([
      "{{ key \"${sandstorm_key_prefix}_ecdsa/cert\" }}",
      "{{ key \"${sandstorm_key_prefix}_ecdsa/intermediate\" }}",
      "{{ key \"${sandstorm_key_prefix}_ecdsa/dhparam\" }}",
    ], "\n")

    twitch_ssl_certificate::certificate { "${name}_ecdsa_cert":
      cert_identifier      => "${name}_ecdsa_cert",
      cert_filesystem_path => "${dir}/${name}_ecdsa_cert.pem",
      cert_contents        => $rsa_contents,
      cert_owner           => $user,
      cert_group           => 'ssl-cert',
      cert_mode            => '0640',
      cert_restart_cmd     => $restart_command,
      key_identifier       => "${name}_ecdsa_key",
      key_filesystem_path  => "${dir}/${name}_ecdsa_key.pem",
      key_contents         => "{{ key \"${sandstorm_key_prefix}_ecdsa/key\" }}",
      key_owner            => $user,
      key_group            => 'ssl-cert',
      key_mode             => '0640',
      key_restart_cmd      => $restart_command,
    }

  }
}
